using System;

namespace Implab {
    public class PromiseReaction<T> : IResolvable<T> {
        IDispatcher m_dispatcher;

        Action<T> m_onFulfilledJob;

        Action<Exception> m_onRejectedJob;

        public void Reject(Exception error) {
            if (m_dispatcher != null)
                m_dispatcher.Enqueue(() => m_onRejectedJob(error));
            else
                m_onRejectedJob(error);
        }

        public void Resolve(T result) {
            if (m_dispatcher != null)
                m_dispatcher.Enqueue(() => m_onFulfilledJob(result));
            else
                m_onFulfilledJob(result);
        }
    }
}